# Core v5.6.5

**Release Date:** January 18, 2025
**Tags:** BUG FIXES, UI/UX, SYSTEM SETTINGS, INTERNATIONALIZATION, MENU TRANSLATIONS

## Fixed

### Menu Translation System

- **Translation Key Display**: Fixed navbar menus showing translation keys (e.g., `admin.dashboard.title`) instead of actual translated text in non-English locales
  - Root cause: `t.raw('.')` method in `useMenuTranslations` hook was attempting to access invalid translation path
  - Removed broken nested object navigation approach
  - Implemented direct translation lookup with proper fallback detection
  - Added multiple validation checks to detect when translation lookup fails
  - Now correctly returns fallback `item.title` when translation not found
- **Translation Path Construction**: Simplified menu key to translation path conversion
  - Direct conversion from hyphenated keys (e.g., `"admin-dashboard"`) to nested paths (e.g., `"admin.dashboard.title"`)
  - Removed unnecessary path splitting and reconstruction logic
  - Eliminated unused `getNestedValue()` helper function
- **Fallback Detection**: Improved detection of failed translations
  - Check if returned value matches the translation key
  - Detect if result contains `.title` or `.description` patterns (indicates unresolved key)
  - Properly fallback to English menu item title/description when translation unavailable

## Added

### System Settings - Market Link Routing

- **Market Link Route Setting**: New configurable system setting to control where market links redirect users
  - Location: System Settings → Trading & Features → Market Link Route
  - Options:
    - **Trading Page** (default) - redirects to `/trade?symbol=BTC-USDT`
    - **Binary Trading** - redirects to `/binary?symbol=BTC-USDT`
  - Applies globally across all market links in the platform
  - Admin can switch routing behavior without code changes

### Utility Functions

- **Market Link Helpers** - New utility functions in `frontend/utils/market-links.ts`
  - `getMarketLinkRoute(settings)`: Returns configured route path (`/trade` or `/binary`)
  - `buildMarketLink(settings, currency, pair)`: Builds complete market URL with symbol parameter
  - Includes validation and automatic fallback to `/trade` if invalid configuration
  - Type-safe implementation with full TypeScript support

## Improved

### Market Page

- **Dynamic Route Links**: Market page now respects market link route setting
  - Market card links use dynamic routing based on system setting
  - Trade action buttons adapt to configured route
  - "Start Trading" CTAs respect admin preference
  - Affected components:
    - Individual market cards (both mobile and desktop)
    - Desktop trade action buttons
    - Bottom CTA section links

### Home Page

- **Dynamic Asset Links**: Home page top assets section now uses dynamic routing
  - Top 5 cryptocurrency asset cards link to configured trading page
  - Seamless integration with existing ticker data and animations
  - Maintains all existing functionality while adding routing flexibility