# Core v5.6.4

**Release Date:** January 17, 2025
**Tags:** BUG FIXES, ECOSYSTEM TRADING, ORDERBOOK INTEGRITY, TRADING UI, CHART FIXES, WEBSOCKET

## Fixed

### Orderbook Integrity

- **Ghost Orders**: Fixed orderbook showing completed/cancelled orders that remain visible indefinitely - added automatic sync on startup to detect and remove ghost entries
- **Amount Mismatches**: Fixed orderbook amounts not reflecting actual open orders after partial fills - system now reconciles orderbook with order database on startup
- **Insufficient Locked Funds**: Fixed "Insufficient locked funds" errors when orders exist but wallet funds aren't locked - validation now checks and fixes unlocked funds automatically
- **Data Inconsistency**: Fixed desync between Scylla orders table and orderbook table when trades fail mid-execution - comprehensive validation ensures consistency

### Trading Interface

- **NaN in Order Forms**: Fixed percentage buttons (25%, 50%, 75%, 100%) showing "NaN" in Amount and Total fields when wallet data is unavailable or price is invalid - added comprehensive validation with safe fallbacks
  - Applied to limit orders
  - Applied to market orders
  - Applied to stop orders
- **Email Verification**: Fixed email verification button only showing alert without sending emails - created missing backend endpoint and updated UI to use proper toast notifications
- **Menu Translation**: Fixed navigation menu titles and descriptions not translating despite translation keys existing - updated all navigation components to use translation hooks
- **ICO Token Calculation**: Fixed incorrect "tokens to receive" display in ICO purchase page - frontend now uses current phase price instead of base offering price

### Chart and Data

- **Real-Time Updates**: Fixed OHLCV chart not updating in real-time when new trades occur at different prices - corrected WebSocket stream format to include interval and symbol
- **Wrong API Endpoint**: Fixed ecosystem markets (MASH/BNB) incorrectly calling exchange provider API instead of ecosystem API - chart now derives market type from URL parameter
- **Gap Filling Errors**: Fixed "xt does not have market symbol" errors when ecosystem markets try to fill historical data gaps through external exchange

### Email System

- **Debug Log Spam**: Removed 31+ excessive debug console.log statements from email sending system
- **Nodemailer Logs**: Disabled verbose debug and logger flags in nodemailer configuration

## Improved

### Orderbook Validation

- **Startup Sync**: Added comprehensive orderbook validation that runs automatically on server startup
  - Compares orderbook entries against actual open orders
  - Detects three types of issues: ghost entries, amount mismatches, missing entries
  - Automatically fixes all discrepancies
  - Broadcasts corrected orderbook to all connected clients
- **Self-Healing**: System now automatically repairs orderbook corruption from past errors without manual intervention

### Order Matching

- **Locked Funds Validation**: Enhanced matching engine to validate locked funds before executing trades
  - Checks seller has sufficient BASE currency locked
  - Checks buyer has sufficient QUOTE currency locked
  - Prevents negative balance errors
  - Gracefully skips invalid matches while keeping valid orders available
- **Order Fixing**: Smart validation distinguishes between fixable orders (funds available but not locked) and invalid orders (insufficient balance)
  - Automatically locks funds for fixable orders
  - Cancels only truly invalid orders
  - Reloads and re-processes fixed orders immediately

### WebSocket Optimization

- **Stream Format**: Simplified OHLCV stream format from `ohlcv:1h:MASH/BNB` to `ohlcv:1h` - symbol is redundant since subscriptions are already filtered per symbol
- **Subscription Logs**: Removed noisy subscription logs that cluttered console output
  - Removed "Added ticker subscription" messages
  - Removed "Active types" array logs
  - Kept important broadcast logs for debugging

### User Experience

- **Error Handling**: Improved error messages and user feedback across trading interface
  - Better validation messages
  - Toast notifications instead of alerts
  - Clearer balance display with validation

## Added

### Orderbook Management

- **syncOrderbookWithOrders()**: New function that reconciles orderbook with actual order states
  - Removes ghost entries (orderbook entries for closed/cancelled orders)
  - Fixes amount mismatches (updates orderbook amounts to match open order totals)
  - Adds missing entries (inserts orderbook entries for orders without them)
  - Runs automatically on matching engine initialization
- **validateAndCleanOrderbook()**: New function that validates wallet locked funds
  - Checks all open orders have sufficient funds locked
  - Fixes orders where user has balance but funds weren't locked
  - Cancels orders where user has insufficient balance
  - Reloads order queue after fixes and re-runs matching

### Trading Features

- **Market Type Detection**: Chart component now intelligently detects market type from URL
  - `type=spot-eco` uses `/api/ecosystem/chart`
  - `type=futures` uses `/api/futures/chart`
  - `type=spot` uses `/api/exchange/chart`
  - Prevents incorrect API calls and error spam

### Email System

- **Email Verification Endpoint**: New `/api/user/profile/verify-email.post.ts` endpoint
  - Allows authenticated users to resend verification emails
  - Validates user authentication
  - Checks if email is already verified
  - Returns clear success/error messages

## Technical Details

### Database Operations

- **Scylla Orderbook Sync**: Direct Scylla operations for orderbook maintenance
  - DELETE queries for ghost entries
  - UPDATE queries for amount corrections
  - INSERT queries for missing entries
  - All operations use prepared statements for performance

### Validation Logic

- **Three-Layer Protection**: Comprehensive order validation system
  1. Runtime validation during matching (prevents errors)
  2. Startup cleanup (fixes past corruption)
  3. Order creation validation (prevents future issues)