# Core v5.5.9

**Release Date:** January 29, 2025
**Tags:** TRADING INTERFACE, ECOSYSTEM MARKETS, ORDER MANAGEMENT, UI IMPROVEMENTS, PAYMENT METHODS, INVESTMENT MANAGEMENT, FOREX TRADING

## Important Note

- **Before updating**: Delete `/frontend/middleware.ts` if present to avoid build conflicts

## Fixed

### Trading Page - Ecosystem Markets

- **Order Cancellation**: Fixed "Failed to cancel order" error for Eco markets
- **Batch Cancellation**: Fixed "Failed to cancel all orders" error for Eco markets
- **Order History**: Fixed cancelled orders now appearing immediately in History tab without page reload
- **Open Orders Display**: Fixed new orders requiring page reload to appear in Open Orders tab - orders now appear instantly
- **Order Book Prices**: Fixed prices showing as 0.000000 for values below 0.01 (e.g., 0.001 now displays correctly)
- **Total Calculations**: Fixed Total column showing 0.00 for small price calculations

### Payment Methods

- **QR Code Support**: Fixed QR Code option not appearing in Type dropdown when creating new deposit methods

### Investment Management

- **Duration Selection**: Fixed duration saving error in AI Investment and Forex plans
- **Menu Visibility**: Fixed Investment Management section not appearing in Finance menu

### Forex Trading

- **Account Type Display**: Fixed Forex account MT version always showing MT4 instead of selected MT5

### Build System

- **⚠️ IMPORTANT**: Before running `pnpm updator`, manually delete `/frontend/middleware.ts` file if it exists
- **Next.js 16 Compatibility**: Cleared middleware/proxy conflict causing build errors

## Improved

### Order Book Enhancements

- **Amount Display**: Improved amount column formatting to strip trailing zeros (e.g., 1.00000000 displays as "1")
- **Price Grouping**: Improved order book grouping with fine-grained aggregation levels supporting micro-cap tokens
- **Aggregation Options**: Expanded aggregation dropdown from 4 to 8 options for better flexibility
- **Decimal Precision**: Enhanced aggregation algorithm for floating-point precision

### Trading Interface

- **Smart Price Formatting**: Prices now display with appropriate decimal places based on value magnitude
- **Real-time Updates**: Orders now appear instantly via WebSocket without requiring page refresh
- **Better Precision**: Support for micro-priced assets and meme coins with tiny prices

## Added

### Investment Features

- **Duration Selection**: Added multiselect duration field to AI Investment plans
- **Forex Durations**: Added multiselect duration field to Forex plans
- **Multiple Durations**: Investment and Forex plans can now select multiple durations when creating or editing

### Payment Methods

- **QR Code Fields**: Added QR Code option to deposit method custom fields in Type dropdown
