# Version 5.2.5

**Release Date:** December 20, 2024  
**Tags:** 2FA SYSTEM, LOGO MANAGEMENT, EMAIL SYSTEM, BUG FIXES, LANGUAGE PERSISTENCE, DEFAULT LANGUAGE, SUPPORT TICKETS, ADMIN MENU

## Fixed

### Two-Factor Authentication
- **Login Endpoint**: Fixed mismatch, now uses correct `/api/auth/otp/login`
- **Email 2FA**: Fixed setup not sending actual OTP codes during verification
- **SMS 2FA**: Fixed allowing configuration without phone number validation
- **Verification Messages**: Fixed inconsistencies between APP, EMAIL, and SMS methods
- **Environment Variables**: Added missing validation for 2FA services
- **Schema Validation**: Fixed missing "EMAIL" enum value in 2FA endpoints

### Language System
- **Language Persistence**: Fixed selection not persisting after page reload
- **User Preferences**: Fixed reverting to default language on refresh
- **Cookie Storage**: Added missing cookie-based language persistence
- **Language Detection**: Fixed only using browser headers instead of saved preferences
- **Default Locale**: Fixed hardcoded default not respecting environment variable

### Support Tickets
- **WebSocket Endpoint**: Fixed completely empty endpoint causing real-time updates to fail
- **Message Posting**: Fixed using raw SQL queries instead of Sequelize
- **JSON Parsing**: Fixed missing JSON field parsing for messages and tags
- **File Upload**: Fixed creating duplicate messages in UI
- **Error Handling**: Added missing error handling preventing server crashes

### Email System
- **Template Placeholders**: Fixed SITE_NAME now displays correctly
- **Text Alignment**: Fixed lists now properly left-aligned
- **Missing Variables**: Fixed template variables and logo URL handling
- **Order Confirmations**: Fixed incomplete order details

### Admin Interface
- **Page Builder**: Fixed "Cannot read properties of undefined" error
- **Logo Display**: Fixed delays caused by settings dependency
- **Menu Extensions**: Fixed not reflecting disabled extension status
- **Extension Toggle**: Fixed not refreshing global settings cache

## Added

### Logo Management
- **Upload System**: Instant platform-wide logo updates
- **Admin Interface**: Management at `/admin/system/logo`
- **Auto Generation**: All logo variants (favicons, app icons)
- **Direct Updates**: Without settings dependency

### Enhanced 2FA System
- **Comprehensive Validation**: For all 2FA methods (SMS, EMAIL, APP)
- **Phone Validation**: Required for SMS 2FA setup
- **OTP Templates**: Professional styling with security warnings
- **Recovery Codes**: Proper generation and consumption
- **Email Verification**: Resend functionality with error handling

### Language Features
- **Cookie Persistence**: 1-year expiration for language preferences
- **Auto Detection**: Cookie priority over browser headers
- **URL Structure**: Proper locale prefix handling
- **Environment Support**: NEXT_PUBLIC_DEFAULT_LANGUAGE variable

### Support System
- **Real-time Updates**: WebSocket functionality for tickets
- **JSON Processing**: Proper parsing for messages and tags
- **Extension Indicators**: Disabled extension visibility in admin
- **Cache Refresh**: For extension status updates
- **Browser Clearing**: Comprehensive cache clearing system

## Improved

### Email Templates
- **Variable Replacement**: Proper processing throughout
- **Order Details**: Detailed breakdown with quantities and pricing
- **Shipping Info**: Enhanced with tax information
- **Template Styling**: Better structure and design
- **Security Messages**: Enhanced in authentication emails

### User Experience
- **2FA Instructions**: Method-specific guidance
- **Language Switching**: Immediate persistence
- **Error Messages**: Better validation throughout
- **Logo Updates**: Automatic file processing
- **Extension Management**: Cleaner layout and improved usability

### System Reliability
- **Error Handling**: Across authentication systems
- **WebSocket Integration**: Real-time support ticket updates
- **File Upload**: Proper validation in support tickets
- **Cache System**: Comprehensive browser storage clearing
- **Settings Refresh**: Automatic cache updates on changes